<?php

namespace apexl\Io\modules\coachingFormsDisplay\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\coachingForms\entities\packagesEntity;
use apexl\Io\modules\coachingForms\entities\questionsEntity;
use apexl\Io\modules\coachingFormsDisplay\components\content;
use apexl\Io\modules\coachingFormsDisplay\components\dataTables;
use apexl\Io\modules\coachingFormsDisplay\components\forms;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\genericForms;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\repeatingFieldGroupField;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class manageCoachingPackagesDisplayController extends coachingDisplayFormsController {

    /**
     * Function to return all packages
     * @route GET /coaching/view-all-packages
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function viewAllPackages(Request $request, Response $response, $args){
        $listTitle = genericComponents::ContentTitle('Available Packages', 'A list of all available coaching packages');
        $formTable = dataTables::manageCoachingFormsPackageList();
        return System::asJson($response, $this->genericPage->wrapper(
            [
                $listTitle,
                $formTable
            ]));
    }

    /**
     * Create package page wrapper
     * @route GET /coaching/manage/create-package
     * @route GET /coaching/manage/packages/{id}/edit
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function manageCreatePackage(Request $request, Response $response, $args){
        return System::asJson($response, $this->genericPage->wrapper([
            content::coachingFormsPackageCreateNewTitle($args),
            forms::createUpdateCoachingPackages($args),
        ]));
    }

    /**
     * Function to build and return the create Package form.
     * @route GET /api/display/forms/coaching/managePackages
     * @route GET /api/display/forms/coaching/managePackages/{id}/edit
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function createPackageForm(Request $request, Response $response, $args){
        $packageEntity = null;
        if($id = $args['id'] ?? FALSE){
            $packageEntity = new packagesEntity();
            $packageEntity->load($args['id']);
        }

        $form = new formEntity();
        $form->setId('createPackageForm');
        $form->setMethod('post');
        $form->setActionUrl('/api/data/coaching-packages'.($id ? '/'.$id : ''));

        //add sky section field
        $repeating = new repeatingFieldGroupField('SkyCoachingForms');
        $repeating->setMaximumGroupRepeats(1);
        $repeating->setGroupPlaceholder('Package name');
        if($packageEntity){
            $repeatingValue = $this->buildQuestionSet([(object)['name' => $packageEntity->name, 'id' => $packageEntity->id]], 'packages', $id);
            $repeating->setValue($repeatingValue);
        }

        $form->addField($repeating);
        return System::asJson($response, $form->getBuiltFormArray());
    }

    /**
     * Delete view for packages, loads the form.
     * @route GET /coaching/manage/packages/{id}/delete
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @return Response
     */
    public function managePackagesDeleteView(Request $request, Response $response, $args = []){
        if($id = $args['id'] ?? FALSE) {
            $package = new packagesEntity();
            $package->load($args['id']);

            //don't boolean check this, we want id 0 to fail (anon) so it can't be deleted.
            if($package->id) {
                $form = genericComponents::formTile('packages', '/api/display/forms/coaching/packages/'.$args['id'].'/delete', 'col-md-12');
                $form->addProperty('header', 3);
                $form->addProperty('title', "Are you sure you want to delete the ".$package->name." package?");
                return System::asJson($response, $this->genericPage->wrapper([$form], 'withBackground'), 200);
            }
            return System::asJson($response, [],404);
        }
        return System::asJson($response, [],400);
    }

    /**
     * Function to generate the package Delete form.
     * @route GET /api/display/forms/coaching/packages/{id}/delete
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function packagesDeleteForm(Request $request, Response $response, $args){
        $form = genericForms::entityActionButtonForm('/api/data/coaching-packages/'.$args['id'].'/delete');
        return System::asJson($response, $form->getBuiltFormArray());
    }
}