<?php

namespace apexl\Io\modules\coachingFormsDisplay\pages;

use apexl\Io\modules\coachingFormsDisplay\components\toolbars;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;

class manageForms{

    /**
     * Used by the callback to override main content initial display.
     * @return componentEntity
     */
    public function manageFormToolbar(){
        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent(toolbars::createFormsButton());
        $toolbarWrapper->addComponent(toolbars::createPackagesButton());

        return $toolbarWrapper;
    }

    public function manageFormToolbarAddCoachingForm(){
        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent(toolbars::viewFormsButton());
        $toolbarWrapper->addComponent(toolbars::createPackagesButton());

        return $toolbarWrapper;
    }

    public function manageFormToolbarAddPackagesForm(){
        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent(toolbars::viewFormsButton());
        $toolbarWrapper->addComponent(toolbars::createFormsButton());

        return $toolbarWrapper;
    }

    public function manageFormAddNew(){
        $toolbarSaveDraftButton = self::formButton(0, 'Save Draft','coachingEvaluations', 'primary', 'save' );
        $toolbarSaveAndPublishButton = self::formButton(1, 'Save & Publish', 'coachingEvaluations','primary', 'upload' );
        $toolbarReviewedButton = self::formButton(2, 'Reviewed', 'coachingEvaluations','primary', 'comments' );

        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent($toolbarSaveDraftButton);
        $toolbarWrapper->addComponent($toolbarSaveAndPublishButton);
        $toolbarWrapper->addComponent($toolbarReviewedButton);

        return $toolbarWrapper;
    }

    public function viewReport($id){
        $editButton = genericComponents::linkButton('/coaching/'.$id.'/edit', 'Edit', 'primary', 'edit' );
        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent($editButton);

        return $toolbarWrapper;
    }

    public function exportReport(){
        $editButton = toolbars::createExportPDFButton();
        $toolbarWrapper = toolbars::toolbarComponent();
        $toolbarWrapper->addComponent($editButton);

        return $toolbarWrapper;
    }

    protected static function formButton($state, $text, $formId, $type = 'primary', $icon = '', $id = NULL){
        $tile = new componentEntity();
        $tile->id = $id ?? $tile->id;
        $tile->name = 'ToolBarButton';
        $tile->classes = 'btn btn-'.$type;
        $tile->addProperty('state', $state);
        $tile->addProperty('icon', $icon);
        $tile->addProperty('text', $text);
        $tile->addProperty('formId', $formId);

        return $tile;
    }

    public function manageFormFilter(){

    }

    public function manageFormListForms(){

    }

    public function manageFormListPackages(){

    }

    public function manageFormPage(){

    }
}