<?php

declare(strict_types=1);

class TitleCase
{
    public static function titleCase(string $string): string
    {
        $wordSplitters = [' ', '-', "O'", "L'", "D'", 'St.', 'Mc'];
        $lowercaseExceptions = ['the', 'van', 'den', 'von', 'und', 'der', 'de', 'da', 'of', 'and', "l'", "d'"];
        $uppercaseExceptions = ['III', 'IV', 'VI', 'VII', 'VIII', 'IX'];

        $string = strtolower((string) $string);
        foreach ($wordSplitters as $delimiter) {
            $words = explode($delimiter, $string);
            $newwords = [];
            foreach ($words as $word) {
                if (in_array(strtoupper($word), $uppercaseExceptions)) {
                    $word = strtoupper($word);
                } elseif (!in_array($word, $lowercaseExceptions)) {
                    $word = ucfirst($word);
                }

                $newwords[] = $word;
            }

            if (in_array(strtolower($delimiter), $lowercaseExceptions)) {
                $delimiter = strtolower($delimiter);
            }

            $string = implode($delimiter, $newwords);
        }

        return $string;
    }
}
