<?php

declare(strict_types=1);

namespace app\vendor\apexl\utils\src\Utils\Strings;

final readonly class After
{
    public static function after(string $string, string $needle, bool $lastOccurrence = false): string
    {
        $pos = strpos($string, $needle);

        if ($pos === false) {
            return $string;
        }

        return ($lastOccurrence)
            ? substr($string, strrpos($string, $needle) + 1)
            : substr($string, $pos + strlen($needle));
    }
}
