<?php

declare(strict_types=1);

namespace apexl\Utils\Strings;

use Stringy\Stringy;

final readonly class Camel
{
    public static function camelCase(string $string, $capitaliseFirst = false): string
    {
        $stringy = Stringy::create($string);

        return (string) ($capitaliseFirst ? $stringy->upperCamelize() : $stringy->camelize());
    }
}
