<?php

declare(strict_types=1);

namespace apexl\Utils\Maths;

final readonly class Sum
{
    public static function sumToInt(int|float|null ...$nums): int
    {
        return (int) self::sum(...$nums);
    }

    public static function sum(int|float|null ...$nums): int|float
    {
        return array_reduce($nums, fn($acc, $value) => $acc + $value ?? 0, 0);
    }

    public static function sumToFloat(int|float|null ...$nums): float
    {
        return (float) self::sum(...$nums);
    }
}
