<?php

declare(strict_types=1);

namespace apexl\Utils\Strings;

final readonly class Pluralizer
{
    public static function plural(string $singular): string
    {
        $last_letter = strtolower($singular[strlen($singular) - 1]);

        return match ($last_letter) {
            'y' => sprintf('%sies', substr($singular, 0, -1)),
            's' => sprintf('%ses', $singular),
            default => sprintf('%ss', $singular),
        };
    }

    public static function singular(string $plural): string
    {
        if (str_ends_with($plural, 'ies')) {
            return sprintf('%sy', substr($plural, 0, -3));
        }

        if (str_ends_with($plural, 'es')) {
            return substr($plural, 0, -2);
        }

        if (str_ends_with($plural, 's')) {
            return substr($plural, 0, -1);
        }

        return $plural;
    }
}
