<?php

namespace apexl\Utils\Strings;

class Sanitize
{
    /**
     * Shamelessly ripped from Wordpress
     * @param $class
     * @param string $fallback
     * @return string|string[]|null
     */
    public static function htmlClassify($class, $fallback = '')
    {
        // Strip out any %-encoded octets.
        $sanitized = preg_replace('|%[a-fA-F0-9][a-fA-F0-9]|', '', $class);

        // Limit to A-Z, a-z, 0-9, '_', '-'.
        $sanitized = preg_replace('/[^A-Za-z0-9_-]/', '', $sanitized);

        if ('' === $sanitized && $fallback) {
            return self::htmlClassify($fallback);
        }

        return $sanitized;
    }
}
