<?php declare(strict_types=1);

namespace apexl\Utils\Strings;

class Camel
{
    public static function camelCase(string $str, $capitaliseFirst = false): string
    {
        $camel = preg_replace('/[^a-z0-9]/i', '', ucwords(strtolower($str), " \t\r\n\f\v-_"));

        if (!$capitaliseFirst) {
            $camel = lcfirst($camel);
        }

        return $camel;
    }
}
