<?php declare(strict_types=1);

namespace apexl\Utils\Strings;

class Phone
{
    public static function normalise(string $phone, string $countryCode = '44'): string
    {
        $out = preg_replace('/[^\d]/', '', $phone);

        if (preg_match('/^(0)/', $out)) {
            $out = preg_replace(sprintf('/^\+?(00?)?(%s)?/', $countryCode), $countryCode, $out);
        }

        return sprintf('+%s', $out);
    }

    public static function stripCountryCode(string $phone, string $countryCode = '44'): string
    {
        return preg_replace(sprintf('/\+?%s/', $countryCode), '0', $phone);
    }
}
