<?php

namespace apexl\Utils\Urls;

class Host
{
    public static function getHost()
    {
        $possibleHostSources = array('HTTP_X_FORWARDED_HOST', 'HTTP_HOST', 'SERVER_NAME', 'SERVER_ADDR');
        $sourceTransformations = array(
            "HTTP_X_FORWARDED_HOST" => function ($value) {
                $elements = explode(',', $value);
                return trim(end($elements));
            }
        );
        $host = '';
        foreach ($possibleHostSources as $source) {
            if (!empty($host)) break;
            if (empty($_SERVER[$source])) continue;
            $host = $_SERVER[$source];
            if (array_key_exists($source, $sourceTransformations)) {
                $host = $sourceTransformations[$source]($host);
            }
        }

        // Remove port number from host
        $host = preg_replace('/:\d+$/', '', $host);

        return trim($host);
    }

    /**
     * Is the current host request under https?
     * @return bool
     */
    public static function isSecure() {
        return
            (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
            || $_SERVER['SERVER_PORT'] == 443;
    }

    /**
     * @param $url
     * @return object
     */
    public static function parseURLAsObject($url){
        $urlObject = (object)parse_url($url);
        $query = $urlObject->query;
        if(!empty($query)){
            $urlObject->queryParts = (object)[];
            if(strpos($query, '&') !== FALSE){
                $elements = explode('&', $query);
            } else {
                $elements = [$query];
            }
            foreach($elements as $argString){
                $args = explode('=', $argString);
                $urlObject->queryParts->{$args[0]} = $args[1];
            }
        }
        if(isset($urlObject->path) && strpos($urlObject->path, '/') !== FALSE){
            $urlObject->pathParts = explode('/', $urlObject->path);
        }
        return $urlObject;
    }
}