<?php

namespace apexl\Vault\interfaces;

use stdClass;

interface driver
{
    public function executeRaw(string $sql): array;

    public function lastInsertId(): int;

    public function update(string $table): driver;

    public function delete(string $table): driver;

    public function insert(string $table): driver;

    public function select(string $table): driver;

    public function fields(?array $fields = null): driver;

    public function keyIsAutoIncrementing(string $keyField, string $table): bool;

    public function createTable(
        string $table,
        stdClass $colList,
        bool $existsCheck = true,
        string $engine = 'INNODB'
    ): driver;

    public function where(
        string $field,
        $value,
        string $condition = '=',
        string $type = 'AND',
        string $postCondition = ''
    ): driver;

    public function resetQueryFields(): void;
}
