<?php

declare (strict_types=1);

namespace apexl\Vault\enums;

use Henzeb\Enumhancer\Concerns\Getters;
use JsonSerializable;

enum SortDirection implements JsonSerializable
{
    use Getters;

    case ASC;
    case DESC;

    case NULL_FIRST_ASC;
    case NULL_FIRST_DESC;
    case NULL_LAST_ASC;
    case NULL_LAST_DESC;

    public function jsonSerialize(): string
    {
        return strtolower($this->name);
    }
}
