<?php

declare(strict_types=1);

namespace apexl\Vault\collections;

use apexl\Vault\dto\joinCondition;
use Arrayy\Collection\AbstractCollection;

/** @extends AbstractCollection<JoinCondition> */
class joinConditionCollection extends AbstractCollection
{

    public static function createFromArray(array $array): joinConditionCollection
    {
        return parent::createFromArray(array_map(self::ensureJoinCondition(...), $array));
    }

    private static function ensureJoinCondition(array|JoinCondition $input): JoinCondition
    {
        if ($input instanceof joinCondition) {
            return $input;
        }

        return JoinCondition::fromArray($input);
    }

    public function getType(): string
    {
        return JoinCondition::class;
    }

    public function toConditionString(): string
    {
        return $this->map(fn(JoinCondition $joinCondition) => $joinCondition->toConditionString())
            ->implode(' AND ');
    }
}
