<?php /** @noinspection PhpUnused */

namespace apexl\Vault\operators\drivers;

use Aura\SqlQuery\QueryFactory;
use PDO as PdoConnection;

class sqlite extends mysql
{
    public function describe(string $table): sqlite
    {
        return $this->executeSql(sprintf('DESCRIBE %s', $table));
    }

    protected function createQueryFactory(): QueryFactory
    {
        return new QueryFactory('sqlite');
    }

    protected function makeConnection(): PdoConnection
    {
        $pdo = new PdoConnection(
            'sqlite:file::memory:?cache=shared',
        );
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        return $pdo;
    }

}
