<?php

declare(strict_types=1);

namespace apexl\Vault\dto;

use apexl\Vault\enums\WhereCondition;

class joinCondition
{

    public function __construct(
        public string $field1,
        public string $field2,
        public WhereCondition $condition = WhereCondition::EQUALS
    ) {
    }

    public static function fromArray(array $input): JoinCondition
    {
        if (isset ($input['field1'])) {
            return new self(
                field1: $input['field1'],
                field2: $input['field2'],
                condition: $input['condition'] ?? WhereCondition::EQUALS
            );
        }

        [$field1, $field2, $condition] = array_pad($input, 3, null);

        return new self(
            field1: $field1,
            field2: $field2,
            condition: $condition ?? WhereCondition::EQUALS,
        );

    }

    public function toConditionString(): string
    {
        return sprintf('%s %s %s', $this->field1, $this->condition->value, $this->field2);
    }
}
