<?php

declare(strict_types=1);

namespace apexl\Vault\enums;

use apexl\Vault\interfaces\ConditionType;
use apexl\Vault\interfaces\driver;
use Henzeb\Enumhancer\Concerns\Getters;

enum WhereType implements ConditionType
{
    use Getters;

    case AND;
    case OR;

    public function toCallable(driver $query): callable
    {
        return match ($this) {
            self::AND => $query->where(...),
            self::OR => $query->orWhere(...),
        };
    }
}
