<?php

declare(strict_types=1);

namespace apexl\Vault\queries;

use Aura\SqlQuery\QueryInterface;

class RawStatement implements QueryInterface
{

    public function __construct(private readonly string $sql, private array $bindValues)
    {
    }

    public function __toString(): string
    {
        return $this->getStatement();
    }

    public function getStatement(): string
    {
        return $this->sql;
    }

    public function getQuoteNamePrefix(): string
    {
        return '"';
    }

    public function getQuoteNameSuffix(): string
    {
        return '"';
    }

    public function bindValues(array $bind_values): void
    {
        $this->bindValues = $bind_values;
    }

    public function bindValue($name, $value): void
    {
        $this->bindValues[$name] = $value;
    }

    public function getBindValues(): array
    {
        return $this->bindValues;
    }

    public function resetFlags(): void
    {
    }
}
