<?php

declare(strict_types=1);

namespace app\vendor\apexl\vault\src\Vault\enums;

use apexl\Vault\interfaces\ConditionType;
use apexl\Vault\interfaces\driver;
use Henzeb\Enumhancer\Concerns\Getters;

enum HavingType implements ConditionType
{
    use Getters;

    case AND;
    case OR;

    public function toCallable(driver $query): callable
    {
        return match ($this) {
            self::AND => $query->having(...),
            self::OR => $query->orHaving(...),
        };
    }
}
