<?php

/**

Plugin Name: Apexl Convert Kit

Plugin URI: https://www.apexlstudios.com

Description: Plugin to connect to the convert Kit API and subscribe new users.

Version: 1.0

Author: Apexl Studios

Author URI: https://www.apexlstudios.com

License: GPL2

 */

use apexl\ConvertKitHelper\ConvertKitHelper;
use apexl\ConvertKitHelper\NoConvertKitIdForUserException;

if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    // Load local autoload if it exists (standalone plugin use)
    require_once __DIR__ . '/vendor/autoload.php';
} elseif (file_exists(__DIR__ . '/../../../../vendor/autoload.php')) {
    // Load Bedrock/Roots autoload
    require_once __DIR__ . '/../../../../vendor/autoload.php';
} else {
    die('Autoloader not found. Please run "composer install" in the appropriate directory.');
}


add_action('user_register', function (int $user_id): void {
    $account = get_userdata($user_id);

    $tags = [
        ConvertKitHelper::tag('CWS_Account_Holder'),
    ];


    if ($submittedInterests = $_POST['com_interests'] ?? null) {
        $interests = ConvertKitHelper::interests();

        foreach ($submittedInterests as $interest) {
            if (isset($interests[$interest])) {
                $tags[] = $interests[$interest];
            }
        }
    }

    switch (($_POST['com_machine'] ?? null)) {
        case 'yes':
            $tags[] = ConvertKitHelper::tag('cutting_machine_yes');
            break;
        case 'no':
            $tags[] = ConvertKitHelper::tag('cutting_machine_no');
            break;
        default:
            break;
    }

    $tags[] = ConvertKitHelper::tag('preferences_set');

    $response = ConvertKitHelper::subscribe(
        '2161576',
        sanitize_text_field($_POST['com_firstname']),
        $account->user_email,
        $tags
    );

    if (!$response->getError()) {
        $subscriberId = $response->data->subscription->subscriber->id;

        update_user_meta($account->ID, 'convert-kit-subscriber-id', $subscriberId);

        return;
    }

    trigger_error(
        sprintf('Unable to fetch ConvertKit Subscriber ID for user %d', $account->ID),
        E_USER_WARNING
    );
    error_log(json_encode($response->getError()), E_USER_NOTICE);
});

add_action('profile_update', function (int $userId, WP_User $oldUserData): void {
    try {
        if ($_POST['com_submit'] ?? null !== 'update-profile') {
            return;
        }

        $subscriberId = ConvertKitHelper::getSubscriberIdForUser($userId);
        $user = get_userdata($userId);

        $convertKitUserData = [];

        if (($email = $_POST['com_email'] ?? null) && $oldUserData->user_email !== $email) {
            $convertKitUserData['email_address'] = $email;
        }
        if (($firstName = $_POST['com_firstname']) && $oldUserData->first_name !== $firstName) {
            $convertKitUserData['first_name'] = $firstName;
        }

        if ($convertKitUserData) {
            ConvertKitHelper::updateUserData($subscriberId, $convertKitUserData);
        }

        if ($submittedInterests = $_POST['com_interests'] ?? []) {
            $currentInterests = array_keys(ConvertKitHelper::interestsForUser($userId));
            if (!((
                count($currentInterests) == count($submittedInterests)
                && !array_diff($currentInterests, $submittedInterests)
            ))) {
                ConvertKitHelper::updateInterestsForUser($userId, $submittedInterests);
            }
        }


        if ($newMachineValue = $_POST['com_machine'] ?? null) {
            $currentMachineValue = ConvertKitHelper::machineTagForUser($userId);
            if ($currentMachineValue !== $newMachineValue) {
                if ($currentMachineValue) {
                    ConvertKitHelper::removeTagFromSubscriber(
                        $subscriberId,
                        ConvertKitHelper::tag(
                            sprintf('cutting_machine_%s', $currentMachineValue)
                        )
                    );
                }

                $user = get_userdata($userId);
                ConvertKitHelper::subscribeUserToTag(
                    $user->user_email,
                    ConvertKitHelper::tag(
                        sprintf('cutting_machine_%s', $newMachineValue)
                    )
                );
            }
        }

        ConvertKitHelper::subscribeUserToTag(
            $user->user_email,
            ConvertKitHelper::tag('preferences_set')
        );
    } catch (NoConvertKitIdForUserException $exception) {
        trigger_error(
            $exception->getMessage(),
            E_USER_WARNING
        );
    }
}, 10, 3);
