<?php

namespace geosim\core\platforms;
use geosim\core\eventLogger;
use geosim\core\interfaces\platformInterface;
use apexl\entityCore\interfaces\EntityOperatorInterface;
use apexl\Vault\Vault;
use n1ghteyes\apicore\client;

abstract class platform implements platformInterface, EntityOperatorInterface{
    //Not a restful API so all method calls go to 'execute.mth' @see sendRequest()

    /** @var client */
    protected $api;
    protected $msisdn;
    protected $iccid;

    protected $apiLogin;
    protected $apiPass;

    protected $simInfo;
    protected $platformName;
    protected $lastMethod;

    protected $vault;
    protected $logger;

    protected function __construct()
    {
        $this->api = new client();
        $this->api->setVersion('v1', FALSE);
        //This is am xml api, so force us to pass a content type of xml.
        $this->vault = Vault::getInstance();
        $this->logger = new eventLogger();
        $this->api->addLogger($this->logger);
    }

    public function setAuth($account, $pass){
        $this->apiLogin = $account;
        $this->apiPass = $pass;
    }

    public function setApiUrl($url, $path = FALSE){
        $this->api->setServer($url);
        $this->api->setBasePath($path);
    }

    public function setSchema($schema){
        $this->api->setSchema($schema);
    }

    public function setSimByMSISDN($msisdn){
        $this->msisdn = $msisdn;
    }

    public function setSimByICCID($iccid){
        $this->iccid = $iccid;
    }

    public function setSimInfo($simInfo){
        $this->simInfo = $simInfo;
        $this->setSimByMSISDN($this->simInfo->msisdn);
        $this->setSimByICCID($this->simInfo->iccid);
    }

    abstract public function getPlatform();
    abstract public function mapResponse($response);

    public function store($data){

    }

    public function load($id){

    }

    public function delete($id){

    }

}