<?php

namespace geosim\core;

use apexl\Vault\Vault;
use n1ghteyes\apicore\interfaces\loggingInterface;

class eventLogger implements loggingInterface {

    protected $method;
    protected $endpoint;
    protected $args;
    protected $url;
    protected $response;
    protected $statusCode;
    protected $requestTime;
    protected $responseTime;

    public function addMethod($method)
    {
        $this->method = $method;
    }

    public function addRawResponse($rawResponse)
    {
        $this->response = $rawResponse;
    }
    public function addRequestArgs($args)
    {
        $this->args = $args;
    }
    public function addRequestEndpoint($endpoint)
    {
        $this->endpoint = $endpoint;
    }

    public function addRequestURL($url)
    {
        $this->url = $url;
    }

    public function addResponseStatusCode($status)
    {
        $this->statusCode = $status;
    }
    public function setRequestTime($time)
    {
        $this->requestTime = $time;
    }
    public function setResponseTime($time)
    {
        $this->responseTime = $time;
    }

    public function store($ident, $apiMethod, $platform){
        //wrap in try/catch, logging shouldn't break the process overall.
        try {
            $data = [
                "identifier" => $ident,
                "endpoint" => $this->endpoint,
                "apiMethod" => $apiMethod,
                "platform" => $platform,
                "requestUrl" => $this->url,
                "requestArgs" => $this->args,
                "requestMethod" => $this->method,
                "requestTime" => $this->requestTime,
                "rawResponse" => $this->response,
                "responseStatusCode" => $this->statusCode,
                "responseTime" => $this->responseTime,
            ];
            $db = Vault::getInstance();
            $db->insert('geosim_api_log')->fields($data)->execute();
        } catch (\Exception $e){
            error_log('[GEOSIM API LOG] '.$e->getCode(). ' :: '.$e->getMessage());
            return FALSE;
        }
    }
}