<?php
namespace geosim\core\platforms;

class manx extends platform {
    protected static $instance;

    protected function __construct()
    {
        parent::__construct();
        $this->api->auth('Content-Type', 'text/xml', 'header');
        $this->api->addCurlOpts([
            'CURLOPT_SSLVERSION' => CURL_SSLVERSION_TLSv1,
            'CURLOPT_SSL_VERIFYPEER' => true,
            'CURLOPT_VERBOSE' => true,
        ]);
    }

    public static function getInstance(){
        if(!self::$instance){
            self::$instance = new manx();
        }
        return self::$instance;
    }

    public function getBalance(){
        return $this->sendRequest('get-customer-balance');
    }

    public function topUp($amount, $info = ''){
        return $this->sendRequest('apply-customer-credit', ['amount' => $amount, 'narrative' => $info]);
    }

    public function deductCredit($amount, $info = ''){
        return $this->sendRequest('apply-customer-debit', ['amount' => $amount, 'narrative' => $info]);
    }

    public function activate(){
        return $this->sendRequest('activate-customer');
    }

    public function getCustomerIdsFromSim(){

    }

    public function getCustomerStatus(){
        return $this->sendRequest('get-customer-status');
    }

    public function suspendCustomer(){
        return $this->sendRequest('suspend-customer');
    }

    public function retireCustomer(){
    }
    public function getDataSession(){}

    public function getHistory($start = '', $end = ''){
        return $this->sendRequest('get-customer-call-history', ['start' => $start, 'end' => $end]);
    }

    public function getSimDetailsMSISDN(){
        return $this->sendRequest('query-sim-details', ['msisdn' => $this->msisdn], 1, FALSE);
    }

    public function getSimDetailsICCID(){
        return $this->sendRequest('query-sim-details', ['iccid' => $this->iccid], 1, FALSE);
    }

    public function getSubscriberDirectoryNumbers(){
        return $this->sendRequest('get-subscriber-directory-numbers');
    }

    public function setCustomerDetails($email){
        return $this->sendRequest('set-customer-details', ['email-address' => $email]);
    }

    public function setSubscriberDetails($fname, $sname){
        return $this->sendRequest('set-subscriber-details', ['first-name' => $fname, 'surname' => $sname]);
    }

    public function setCustomerTerms($level){
        return $this->sendRequest('set-customer-terms', ['credit-basis' => 'pre-paid', 'credit-warning' => $level]);
    }

    public function setDirectoryNumber($directoryNumber){
        return $this->sendRequest('set-subscriber-cli', ['directory-number' => $directoryNumber]);
    }

    public function locateSim(){
        return $this->sendRequest('locate-subscriber', ['poll-current-location' => 'true']);
    }

    public function getPlatform(){
        return __CLASS__;
    }

    public function mapResponse($response)
    {
        return $response;
    }

    protected function buildRequest($method, $data, $version, $number){
        $xml = '<'.$method.' version="'.$version.'">';
        $xml .= '<authentication><username>'.$this->apiLogin.'</username><password>'.$this->apiPass.'</password></authentication>';
        $xml .= $number ? '<number>'.$this->msisdn.'</number>' : '';
        if(!empty($data)) {
            foreach ($data as $field => $value) {
                $xml .= '<' . $field . '>' . $value . '</' . $field . '>';
            }
        }
        $xml .= '</'.$method.'>';
        return $xml;
    }

    protected function sendRequest($method, $data = [], $version = 1, $number = TRUE){
        $response = $this->api->POST->{'execute.mth'}($this->buildRequest($method, $data, $version, $number));
        $this->logger->store($this->msisdn, $method, 'manx');
        return $response->data;
    }
}