<?php
namespace geosim\core\platforms;

use apexl\Config\Singleton;

class jasper extends platform {
    protected static $instance;
    protected $config;
    protected function __construct()
    {
        parent::__construct();
        $this->config = Singleton::getInstance();
        //$this->api->setBodyFormat('form_params');
        $this->api->auth($this->apiLogin, $this->apiPass);
        $this->api->auth('Content-Type', 'application/json', 'header');
        $this->api->setBodyFormat('json');
        $this->api->addCurlOpts([
            'CURLOPT_SSLVERSION' => CURL_SSLVERSION_TLSv1_1,
            'CURLOPT_SSL_VERIFYPEER' => FALSE,
            'CURLOPT_VERBOSE' => true,
        ]);
    }

    public static function getInstance(){
        if(!self::$instance){
            self::$instance = new jasper();
        }
        return self::$instance;
    }

    public function setAuth($account, $pass){
        parent::setAuth($account, $pass);
        $this->api->auth($this->apiLogin, $this->apiPass);
    }

    public function getBalance(){
        return '';
    }

    public function topUp($amount, $info = ''){
        return '';
    }

    public function deductCredit($amount, $info = ''){
        return '';
    }

    public function activate(){
        $this->api->resetPath();
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['status' => 'ACTIVATED']);
        $this->logger->store($this->iccid, 'activate', 'jasper');
        return (array) $data->data;
    }

    public function getCustomerIdsFromSim(){
        return '';
    }

    public function suspendCustomer(){
        $this->api->resetPath();
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['status' => 'DEACTIVATED']);
        $this->logger->store($this->iccid, 'suspendCustomer', 'jasper');
        return (array) $data->data;
    }

    public function retireCustomer(){
        $this->api->resetPath();
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['status' => 'RETIRED']); // '@Todo change this to RETIRED
        $this->logger->store($this->iccid, 'retireCustomer', 'jasper');
        return (array) $data->data;
    }

    public function moveSimCustomer($customer){
        $this->api->resetPath();
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['customer' => $customer]);
        $this->logger->store($this->iccid, 'moveSimCustomer', 'jasper');
        return (array) $data->data;
    }

    public function getDevices($accountId, $pageNumber = 1, $modifiedSince = '2019-08-08T00:00:00+00:00'){
        $this->api->resetPath();
        $data = $this->api->GET->devices(['accountId' => $accountId, 'pageNumber' => $pageNumber, 'modifiedSince' => $modifiedSince]);
        $this->logger->store($accountId, 'getDevices', 'jasper');
        return (array) $data->data;
    }

    public function sendSMS($message){
        $this->api->resetPath();
        $data = $this->api->POST->devices->{$this->iccid}->smsMessages(['messageText' => $message]);
        $this->logger->store($this->iccid, 'sendSMS', 'jasper');
        return (array) $data->data;
    }

    public function setCustomerDataField($customer, $consumerId = ''){
        $this->api->resetPath();
        $data = [
            'customer' => 'Global M2M SIM.com',
            'accountCustom2' => $customer[2],
            'accountCustom10' => $customer[10],
        ];
        if($customer[3] ?? FALSE){
            $data['accountCustom3'] = $customer[3];
        }
        if($customer[4] ?? FALSE){
            $data['accountCustom4'] = $customer[4];
        }
        if($customer[5] ?? FALSE){
            $data['accountCustom5'] = $customer[5];
        }
        $data = $this->api->PUT->devices->{'_'.$this->iccid}($data);
        $this->logger->store($this->iccid, 'setCustomerDataField', 'jasper');
        return (array) $data->data;
    }

    /**
     * Override the default __call for this method, since we get data from the reporting database NOT the cloud9 API.
     */
    public function getHistory($start = '', $end = ''){
        return '';
    }

    public function getSimDetailsMSISDN(){
        return '';
    }

    public function getSimDetailsICCID(){
        $this->api->resetPath();
        $data = $this->api->GET->devices->{'_'.$this->iccid}(['fields' => 'status,iccid,communicationPlan,ratePlan,accountCustom2,accountCustom3,accountCustom4,accountCustom5,accountCustom6,accountCustom7,accountCustom8,accountCustom9,accountCustom10,customer,msisdn,dateActivated']);
        $this->logger->store($this->iccid, 'getSimDetailsICCID','jasper');
        //fix a known bug in jasper where msisdn numbers are missing the initial 353 code.
        return (array) $data->data;
    }

    public function setSumCommunicationPlan($commsPlan = 'NGL - Zone C (3Extra) D'){
        $this->api->resetPath();
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['communicationPlan' => $commsPlan]);
        $this->logger->store($this->iccid, 'setSumCommunicationPlan', 'jasper');
        return (array) $data->data;
    }

    public function getUsage(){
        $this->api->resetPath();
        $data = $this->api->GET->devices->{$this->iccid}->ctdUsages();
        $this->logger->store($this->iccid, 'getUsage','jasper');
        //fix a known bug in jasper where msisdn numbers are missing the initial 353 code.
        return (array) $data->data;
    }

    public function getDataSession(){
        $this->api->resetPath();
        $data = $this->api->GET->devices->{$this->iccid}->sessionInfo();
        $this->logger->store($this->iccid, 'getDataSession','jasper');
        //fix a known bug in jasper where msisdn numbers are missing the initial 353 code.
        return (array) $data->data;
    }

    public function setCustomerTerms($level){
        return '';
    }


    public function getSubscriberDirectoryNumbers(){
        return $this->msisdn;
    }

    public function getCustomerStatus(){
        return $this->getSimDetailsICCID();
    }

    public function getUserInfo(){
        return '';
    }

    public function setCustomerDetails($email){
        return '';
    }

    public function getCustomerInfo(){
        return '';
    }

    public function setSubscriberDetails($fname, $sname){
        return '';
    }

    public function setDirectoryNumber($directoryNumber){
    }

    public function locateSim($lbsAcc, $lbsPw, $adminAcc, $adminPw){
        $this->api->resetPath();

        //https://restapi3.jasper.com/rws/api/v{apiVersion}/devices/{iccid}/locationHistory
        $this->api->auth($lbsAcc, $lbsPw);
        $data = $this->api->GET->devices->{$this->iccid}->locationHistory();
        $this->logger->store($this->iccid, 'locateSim','jasper');
        $this->api->auth($adminAcc, $adminPw);

        return (array) $data->data;
    }

    public function getPlatform(){
        return __CLASS__;
    }

    public function mapResponse($response)
    {
        $data = [];
        switch($this->lastMethod){
            case 'BalanceStatus':
                $data['balance'] = $response['balance']['balancevalue'];
                $data['cleared-balance'] = FALSE;
                $data['pending-balance'] = FALSE;
                break;
            case 'SimInformationByMSISDN':
                $data = $response;
                $data['iccid'] = $response['Sim']['IccId'];
                $data['identities']['identity']['imsi'] = $response['Sim']['Imsi'];
                $data['identities']['identity']['primary-msisdn'] = $response['Sim']['ActiveProfile'];
                break;
            case 'GetSimStatus':
                //we also need to get warning trigger info, so grab that as well.
                $customerInfo = $this->getCustomerInfo();
                $data = $response;
                $data['customer-status'] = $response['SimStatus'] == 'Enabled' ? 'active' : 'suspended';
                break;
            case 'getCustomerStatus':
                $data = $response;
                $data['customer-status'] = $response['status'] == 'ACTIVATED' ? 'active' : 'suspended';
                break;
            default:
                $data = $response;
                break;
        }
        return $data;
    }
}