<?php
namespace geosim\core\platforms;

class cloud9 extends platform {
    protected static $instance;

    protected function __construct()
    {
        parent::__construct();
        //$this->api->setBodyFormat('form_params');
        $this->api->auth('Content-Type', 'text/xml', 'header');
        $this->api->addCurlOpts([
            'CURLOPT_SSLVERSION' => CURL_SSLVERSION_TLSv1_1,
            'CURLOPT_SSL_VERIFYPEER' => FALSE,
            'CURLOPT_VERBOSE' => true,
        ]);
    }

    public static function getInstance(){
        if(!self::$instance){
            self::$instance = new cloud9();
        }
        return self::$instance;
    }

    public function getBalance(){
        return $this->sendRequest('BalanceStatus', ['Customer' => ['ID' => $this->simInfo->customerId]]);
    }

    public function topUp($amount, $info = ''){
        //we need to create a prepaid batch and then redeem it.
        $this->sendRequest('AddPrePaidCredit',
            ['Credit' => ['CustomerID' => $this->simInfo->customerId, 'Amount' => $amount, 'Narrative' => $info]]
        );
        return $this->getBalance();
    }

    public function deductCredit($amount, $info = ''){
        $this->sendRequest('AdhocDebit', ['Debit' => ['CustomerID' => $this->simInfo->customerId, 'Amount' => $amount, 'Narrative' => $info]]);
        return $this->getBalance();
    }

    public function activate(){
        $this->sendRequest('EnableUser', ['User' => ['ID' => $this->simInfo->userId]]);

        $data = [
            'ICCID' => $this->iccid,
            'SimStatus' => 'Enabled',
            'DataStatus' => 'Enabled',
            'CamelStatus' => 'Enabled',
            'LowCreditWarning' => 'Enabled',
        ];

        $this->sendRequest('SetSimStatus', $data);
        return $this->assignMsisdn();
    }

    public function getCustomerIdsFromSim(){
        return $this->sendRequest('UserCustID', ['SIM' => ['ICC-ID' => $this->iccid]]);
    }

    public function suspendCustomer(){
        return $this->sendRequest('DisableUser', ['User' => ['ID' => $this->simInfo->userId]]);
    }

    public function retireCustomer(){
    }
    public function getDataSession(){}

    public function assignMsisdn(){
        $assignMsisdn = $this->sendRequest('AssignMsisdn', ['SIM' => ['ICCID' => $this->iccid]]);
        $assignMsisdn['UpdateLocalRecord'] = TRUE;
        return $assignMsisdn;
    }

    /**
     * Override the default __call for this method, since we get data from the reporting database NOT the cloud9 API.
     */
    public function getHistory($start = '', $end = ''){
        $simHistory = $this->vault->reporting->select("c9Reports")->fields()->where("User", $this->msisdn)->where("CreateTime", $start, '>=')->where("CreateTime", $end, '<=')->execute()->fetchAll();
        //return $this->sendRequest('GetFullCallHistoryForAnMSISDN', ['MSISDN' => $this->msisdn, 'StartDate' => $start, 'EndDate' => $end]);
        $callList = [];
        foreach($simHistory as $row) {
            $call = [];
            $call['id'] = $row->CallID;
            $call['create-time'] = $row->CreateTime;
            $call['narrative'] = $row->Bdescription;
            $call['leg1'] = $row->Reference;
            $call['leg2'] = $row->Customer;
            $call['type'] = $row->CallType;
            $call['outcome'] = $row->Seconds == NULL ? 'No data transferred' :  'Success';
            $call['duration'] = date('H:i:s', $row->Seconds);
            $call['retail-charge'] = $row->RetailCost;
            $callList[] = $call;
        }
        return ['call-history' => ['call' => $callList]];
    }

    public function getSimDetailsMSISDN(){
        return $this->sendRequest('SimInformationByMSISDN', ['MSISDN' => $this->msisdn]);
    }
    public function getSimDetailsICCID(){
        return $this->sendRequest('SimInformationByMSISDN', ['ICCID' => $this->iccid]);
    }

    public function setCustomerTerms($level){
        return $this->sendRequest('GetSetWarningTrigger', ['Customer' => ['ID' => $this->simInfo->customerId, 'WarningTrigger' => $level]]);
    }


    public function getSubscriberDirectoryNumbers(){
        //only 1 number.
        return $this->msisdn;
        //return $this->sendRequest('get-subscriber-directory-numbers');
    }

    public function getCustomerStatus(){
        return $this->sendRequest('GetSimStatus', ['MSISDN' => $this->msisdn]);
    }

    public function getUserInfo(){
        return $this->sendRequest('GetUserInfo', ['User' => ['UserID' => $this->simInfo->userId]]);
    }

    public function setCustomerDetails($email){
        $user = $this->getUserInfo();
        $user['Contact']['Email'] = $email;
        $user['User']['ID'] = $this->simInfo->userId;
        return $this->sendRequest('ModifyUser', $user);
    }

    public function getCustomerInfo(){
        return $this->sendRequest('GetCustomerInfo', ['Customer' => ['CustomerID' => $this->simInfo->customerId]]);
    }

    public function setSubscriberDetails($fname, $sname){
        $customer = $this->getCustomerInfo();
        $msisdn = $this->simInfo->msisdn;
        $customer['Customer']['ID'] = $this->simInfo->customerId;
        $customer['Customer']['CompanyName'] = $fname. ' '. $sname. ' '. $msisdn;
        //CompanyName
        return $this->sendRequest('ModifyCustomer', $customer);
    }

    public function setDirectoryNumber($directoryNumber){
        //return $this->sendRequest('set-subscriber-cli', ['directory-number' => $directoryNumber]);
    }

    public function locateSim(){
        //nothing in place for this
        //return $this->sendRequest('locate-subscriber', ['poll-current-location' => 'true']);
    }

    /**
     * Transfer credit from an agent to a dealer.
     * @param $agentId
     * @param $dealerId
     * @param $amount
     * @return mixed
     */
    public function transferAgentCredit($agentId, $dealerId, $amount){
        return $this->sendRequest('agentbalancetransfer', ['agents' => ['credit' => $dealerId, 'debit' => $agentId, 'amount' => $amount]]);
    }

    public function GetAgentBalance($agentId){
        return $this->sendRequest('GetAgentBalance', ['Agent' => ['ID' => $agentId]]);
    }

    public function getPlatform(){
        return __CLASS__;
    }

    public function mapResponse($response)
    {
        $data = [];
        switch($this->lastMethod){
            case 'BalanceStatus':
                $data['balance'] = $response['balance']['balancevalue'];
                $data['cleared-balance'] = FALSE;
                $data['pending-balance'] = FALSE;
                break;
            case 'SimInformationByMSISDN':
                $data = $response;
                $data['iccid'] = $response['Sim']['IccId'];
                $data['identities']['identity']['imsi'] = $response['Sim']['Imsi'];
                $data['identities']['identity']['primary-msisdn'] = $response['Sim']['ActiveProfile'];
                break;
            case 'GetSimStatus':
                //we also need to get warning trigger info, so grab that as well.
                $customerInfo = $this->getCustomerInfo();
                $data = $response;
                $data['customer-status'] = $response['SimStatus'] == 'Enabled' ? 'active' : 'suspended';
                $data['credit-warning'] = $customerInfo['Customer']['WarningTrigger'];
                break;
            case 'ModifyUser':
                $data = $response;
                $data['@attributes']['trid'] = $response['user']['id'];
                break;
            default:
                $data = $response;
                break;
        }
        return $data;
    }

    protected function buildRequest($method, $data){
        $xml = '<?xml version="1.0"?><'.$method.'>';
        $xml .= '<authentication><Username>'.$this->apiLogin.'</Username><Password>'.$this->apiPass.'</Password></authentication>';
        if(!empty($data)) {
            foreach ($data as $field => $value) {
                $xml .= '<' . $field . '>';
                if(is_array($value)){
                    foreach($value as $subField => $subValue){
                        $xml .= '<' . $subField . '>'.$subValue.'</' . $subField . '>';
                    }
                } else {
                    $xml .= $value;
                }
                $xml .= '</' . $field . '>';
            }
        }
        $xml .= '</'.$method.'>';
        return $xml;
    }

    protected function sendRequest($method, $data = []){
        $this->lastMethod = $method;
        $response = $this->api->POST->{'version400.aspx'}($this->buildRequest($method, $data));
        $this->logger->store($this->iccid ?? $this->msisdn ?? 'Agent Request', $method,'cloud9');
        return $response->data;
    }
}