<?php
namespace geosim\core\platforms;

use apexl\Config\Singleton;
use GuzzleHttp\Client;

class nokia extends platform {

    protected static $instance;
    protected $config;
    protected $accessToken = null;
    protected $guzzleClient;
    protected $simCustomFields = null;

    protected $baseUrl = 'https://3ielab.nokiawing.com/';

    protected $requestStack = [];

    protected function __construct()
    {
        parent::__construct();
        $this->config = Singleton::getInstance();
    }

    public static function getInstance(){
        if(!self::$instance){
            self::$instance = new nokia();
        }
        return self::$instance;
    }

    public function setAuth($account, $pass){
        parent::setAuth($account, $pass);
    }

    public function getBalance(){
        return '';
    }

    public function topUp($amount, $info = ''){
        return '';
    }

    public function deductCredit($amount, $info = ''){
        return '';
    }

    public function activate(){
        $data = $this->makeRequest('POST', "sim/update_state", (object)[
            'iccid' => $this->iccid,
            'newState' => 'ACTIVE',
            'newStateId' => 3
        ]);
        $this->logger->store($this->iccid, 'activate', 'nokia');
        return (array) $data->data;
    }

    public function getCustomerIdsFromSim(){
        return '';
    }

    public function suspendCustomer(){
        $data = $this->makeRequest('POST', "sim/update_state", (object)[
            'iccid' => $this->iccid,
            'newState' => 'DEACTIVATED',
            'newStateId' => 8
        ]);
        $this->logger->store($this->iccid, 'suspendCustomer', 'nokia');
        return (array) $data->data;
    }


    public function moveSimCustomer($customer){
        $data = $this->api->PUT->devices->{'_'.$this->iccid}(['customer' => $customer]);
        $this->logger->store($this->iccid, 'moveSimCustomer', 'nokia');
        return (array) $data->data;
    }

    public function getDevices($accountId, $pageNumber = 1, $modifiedSince = '2019-08-08T00:00:00+00:00'){
        $data = $this->api->GET->devices(['accountId' => $accountId, 'pageNumber' => $pageNumber, 'modifiedSince' => $modifiedSince]);
        $this->logger->store($accountId, 'getDevices', 'nokia');
        return (array) $data->data;
    }

    public function sendSMS($message){
        $data = $this->makeRequest('POST', "notification/sms/sendsms", (object)[
            'to' => $this->msisdn,
            'message' => $message,
        ]);
        $this->logger->store($this->iccid, 'sendSMS', 'nokia');
        return (array) $data->data;
    }

    public function setCustomerDataField($customer, $consumerId = ''){

        $data = $this->assignSimToCustomer('Global M2M SIM.com');

        $simData = $this->getSimDetailsSimple(true);

        $this->updateSimCustomField($simData['id'], "sim  notes", "test");  // This is a Test

        foreach ([2,10,3,4,5] as $updateIfTrueId) {
            if ($customer[$updateIfTrueId] ?? false) {
                $this->updateSimCustomField($simData['id'], "accountCustom$updateIfTrueId", $customer[$updateIfTrueId]);
            }
        }

        return (array)[
            'iccid' => $this->iccid,
        ];
    }

    protected function assignSimToCustomer($customer)
    {
        //{"iccid":"1955644099890004111","imsi":"234509001014111","accountId":6501,"groupId":18351}
        if ($groupId = $this->getCustomerIdByName($customer)) {
            $data = $this->makeRequest('PUT', "subscription/sims/group", (object)[
                'iccid' => $this->iccid,
                'accountId' => $this->getNokiaAccountId(),
                'groupId' => $groupId
            ]);
            $this->logger->store($this->iccid, 'setCustomerDataField', 'nokia');
            return $data->data;
        }
    }

    /**
     * Override the default __call for this method, since we get data from the reporting database NOT the cloud9 API.
     */
    public function getHistory($start = '', $end = ''){
        return '';
    }

    public function getSimDetailsMSISDN(){
        return '';
    }

    public function getSimDetailsICCID(){

        $data = $this->getSimDetailsSimple();
        //fix a known bug in jasper where msisdn numbers are missing the initial 353 code.

        if (isset($data->data->groupId) && $data->data->groupId) {
            if ($customer = $this->getCustomerNameForSim($data->data->groupId)) {
                $data->data->customer = $customer;
            }
        }
        if ($data->data->networkProfileId ?? null) {// Network Profile Name
            $commsPlans = $this->getCommsPlanByIds([$data->data->networkProfileId]);
            $data->data->communicationPlan = $commsPlans[0]->name ?? "";
        }
        if ($data->data->stateName ?? null) { // Map Status
            $data->data->status = $this->mapSimStatus($data->data->stateName);
        }
        if ($data->data->ratePlanId ?? null) { // Get Rate Plan Name
            $data->data->ratePlan = $this->getRatePlanById($data->data->ratePlanId);
        }
        if ($data->data->id ?? null) { // Get custom fields
            $customFields = $this->getSimCustomFields($data->data->id);
            if (is_array($customFields)) {
                foreach ($customFields as $field) {
                    $data->data->{$field->name} = $field->value;
                }
            }
        }

        return (array)($data->data ?? []);
    }

    protected function getSimDetailsSimple($asArray=false)
    {
        $data = $this->makeRequest('GET', "subscription/sims/iccid/{$this->iccid}");
        $this->logger->store($this->iccid, 'getSimDetailsICCID','nokia');

        if ($asArray) return (array)($data->data ?? []);

        return $data;
    }

    protected function updateSimCustomField($simId, $name, $value, $createIfNotExists=false)
    {
        $fields = $this->getSimCustomFields($simId);
        if (is_null($fields)) return; // If request to get sim custom fields failed,  exit here to avoid dodgy updates!

        $updated = false;
        $fieldExists = false;
        foreach ($fields as $field) {
            if ($field->name == $name) {
                $fieldExists = true;
                if ($field->value != $value) {
                    $field->value = $value;
                    $data = $this->makeRequest('PUT', "customfield/updateSubscriptionCustomField/$simId", $field);
                    $this->logger->store($this->iccid, 'updateSimCustomField','nokia');
                    $updated = true;
                }
            }
        }

        if ($createIfNotExists && !$fieldExists) {
            // Create new custom field
            // Can't do this - there's an error in the Nokia API docs - question to Greg
        }

        return $updated;
    }


    protected function getSimCustomFields($simId)
    {
        if (is_null($this->simCustomFields)) {
            $fields = [];
            $data = $this->makeRequest('GET', "customfield/getAllCustomFields/$simId");
            $this->logger->store($this->iccid, 'getSimCustomFields','nokia');
            if ($data->statusCode != 200) {
                $this->simCustomFields = null;
            } else {
                $this->simCustomFields = $data->data ?? [];
            }
        }

        return $this->simCustomFields;
    }

    protected function getCustomerNameForSim($groupId)
    {
        $customers = $this->getCustomers();

        if (isset($customers) && is_array($customers)) {
            foreach ($customers as $group) {
                if ($group->id == $groupId) {
                    return $group->name;
                }
            }
        }

        return null;
    }

    protected function getCustomerIdByName($customerName, $createIfNotExists=true)
    {
        $customers = $this->getCustomers();

        if (isset($customers) && is_array($customers)) {
            foreach ($customers as $group) {
                if ($group->name == $customerName) {
                    return $group->id;
                }
            }
        }

        if ($createIfNotExists) { // Create customer record as it doesn't exist yet
            $group = $this->createCustomer($customerName);
            return $group->id ?? null;
        }

        return null;
    }

    protected function getCustomers() // (Customers are called Groups in Nokia)
    {
        $data = $this->makeRequest('POST', "graphql", (object)[
            'query' => 'query {accmgmt_tbl_groups(where:{_and:[{tenant_id:{_eq:"'.$this->getNokiaTenantId().'"}}{account_master_id:{_eq:"'.$this->getNokiaAccountId().'"}}]}){name account_master_id id}}',
        ]);
        $this->logger->store($this->iccid, 'getGroups','nokia');
        return $data->data->data->accmgmt_tbl_groups ?? null;
    }

    protected function createCustomer($customerName) // (Customers are called Groups in Nokia)
    {
        $data = $this->makeRequest('POST', "accounts/groups", (object)[
            'name' => $customerName,
            'description' => $customerName
        ]);
        $this->logger->store($this->iccid, 'createCustomer','nokia');
        return $data->data ?? null;
    }

    protected function getRatePlanById($ratePlanId)
    {
        $data = $this->makeRequest('GET', "rating/getrateplans");
        $this->logger->store($this->getNokiaAccountId(), 'getRatePlans', 'nokia');

        if (isset($data->data) && is_array($data->data)) {
            foreach ($data->data as $plan) {
                if ($plan->id == $ratePlanId) return $plan->name;
            }
        }

        return "none";
    }

    public function setSumCommunicationPlan($commsPlan = 'NGL - Zone C (3Extra) D'){

        // ToDo - get network profile ID by name
        $data = $this->makeRequest('GET', "accounts/account/{$this->getNokiaAccountId()}/resources?resourceType.equals=SERVICE-PROFILE");
        $this->logger->store($this->getNokiaAccountId(), 'getNetworkProfiles', 'nokia');

        $ids = [];
        if (isset($data->data) && is_array($data->data)) {
            foreach ($data->data as $networkProfile) {
                $ids[] = $networkProfile->resourceId;
            }
        }

        $newNetworkProfileId = null;
        $commsPlans = $this->getCommsPlanByIds($ids);
        foreach ($commsPlans as $plan) {
            if (strtolower($commsPlan) == strtolower($plan->name)) {
                $newNetworkProfileId = $plan->id;
                break;
            }
        }

        if (!is_null($newNetworkProfileId)) {
            $data = $this->getSimDetailsSimple(true);

            $data = $this->makeRequest('POST', "sim/assign_service_profile", (object)[
                'iccid' => $this->iccid,
                'imsi' => $data['imsi'],
                'networkProfileId' => $newNetworkProfileId,
                'serviceProfileId' => $newNetworkProfileId,
            ]);
            $this->logger->store($this->iccid, 'setCommunicationPlan', 'nokia');
        }

        return (array) $data->data;
    }

    protected function getCommsPlanByIds($ids=[])
    {
        $commsPlans = [];
        if (count($ids) > 0) {
            $data = $this->makeRequest('POST', "graphql", (object)[
                'query' => 'query Get_resourcemanagement_service_profile {resourcemanagement_service_profile(limit: '.count($ids).', offset: 0,where:{_and:[{tenant_id:{_eq:"'.$this->getNokiaTenantId().'"}}{id: {_in: ['.implode(',',$ids).']}}]}){cs_data data_2_g_3_g data_4_g data_roaming_2_g_3_g data_roaming_4_g description id name rat_type resource_type_id sms_mo sms_mt state_id tenant_id voice_mo voice_mt voice_boic sms_boiexh premium_num service_profile_allocations{account_id archieved id service_profile_id tenant_id}}}',
            ]);
            $this->logger->store($this->iccid, 'getNetworkProfiles','nokia');
            if (isset($data->data->data->resourcemanagement_service_profile) && is_array($data->data->data->resourcemanagement_service_profile)) {
                foreach ($data->data->data->resourcemanagement_service_profile as $profile) {
                    $commsPlans[] = $profile;
                }
            }
        }

        return $commsPlans;
    }


    public function getUsage(){

        $simData = $this->getSimDetailsSimple(true);
        if (isset($simData['tenantId']) && isset($simData['id'])) {
            // 1. Get Data
            $data = $this->makeRequest('POST', "graphql", (object)[
                'query' => 'query DataUsageOnline{restgw_tbl_subscriber_data_balance_aggregate(order_by:{id:desc}where:{_and:[{subscription_id_data0:{_eq:"'.$simData['imsi'].'"}}{accumulator_type:{_eq:"Billing-Cycle"}}{active:{_eq:"true"}}]}){aggregate{sum{accumulated_usage}}}}',
                'variables' => null,
                'operationName' => 'DataUsageOnline'
            ]);
            $this->logger->store($this->iccid, 'getUsage','nokia');
            // 2. Get SMS and Voice
            $data = $this->makeRequest('POST', "graphql", (object)[
                'query' => 'query DataUsageOffline{rating_usage_accumulator(order_by:{id:desc}limit:1where:{_and:[{tenant_id:{_eq:"'.$simData['tenantId'].'"}}{subscription_id:{_eq:"'.$simData['id'].'"}}{counter_type:{_eq:"Monthly"}}]}){counter_sms_mo counter_sms_mt counter_voice_mo counter_voice_mt counter_data}}',
                'variables' => null,
                'operationName' => 'DataUsageOffline'
            ]);
            $this->logger->store($this->iccid, 'getUsage','nokia');
        }


        $this->logger->store($this->iccid, 'getUsage','nokia');
        //fix a known bug in jasper where msisdn numbers are missing the initial 353 code.
        return (array) $data->data;
    }

    public function setCustomerTerms($level){
        return '';
    }


    public function getSubscriberDirectoryNumbers(){
        return $this->msisdn;
    }

    public function getCustomerStatus(){
        return $this->getSimDetailsICCID();
    }

    public function getUserInfo(){
        return '';
    }

    public function setCustomerDetails($email){
        return '';
    }

    public function getCustomerInfo(){
        return '';
    }

    public function setSubscriberDetails($fname, $sname){
        return '';
    }

    public function setDirectoryNumber($directoryNumber){
    }

    public function locateSim(){

    }

    public function getPlatform(){
        return __CLASS__;
    }

    protected function mapSimStatus($simStatus)
    {
        switch ($simStatus) {
            case 'TRIAL':
                return 'TEST_READY';
                break;
            case 'ACTIVE':
                return 'ACTIVATED';
                break;
            case 'ENTERPRISE-INVENTORY':
                return 'ACTIVATION_READY';
                break;
        }

        /*"State ID State Name
        1 ENTERPRISE-INVENTORY
        4 SUSPENDED
        5 REGULATORY-HOLD
        6 CSP-HOLD
        7 CONDITIONAL-SUSPEND
        8 DEACTIVATED
        9 RETIRED
        10 DEALLOCATED
        2 TRIAL
        3 ACTIVE"*/

        return $simStatus;
    }

    public function mapResponse($response)
    {
        $data = [];
        switch($this->lastMethod){
            /*case 'BalanceStatus':
                $data['balance'] = $response['balance']['balancevalue'];
                $data['cleared-balance'] = FALSE;
                $data['pending-balance'] = FALSE;
                break;
            case 'SimInformationByMSISDN':
                $data = $response;
                $data['iccid'] = $response['Sim']['IccId'];
                $data['identities']['identity']['imsi'] = $response['Sim']['Imsi'];
                $data['identities']['identity']['primary-msisdn'] = $response['Sim']['ActiveProfile'];
                break;
            case 'GetSimStatus':
                //we also need to get warning trigger info, so grab that as well.
                $customerInfo = $this->getCustomerInfo();
                $data = $response;
                $data['customer-status'] = $response['SimStatus'] == 'Enabled' ? 'active' : 'suspended';
                break;
            case 'getCustomerStatus':
                $data = $response;
                $data['customer-status'] = $response['status'] == 'ACTIVATED' ? 'active' : 'suspended';
                break;*/
            default:
                $data = $response;
                break;
        }
        return $data;
    }

    protected function setPreCallLoggingInformation($method, $url, $requestData, $path)
    {
        if ($this->logger !== null) {
            $this->logger->addMethod($method);
            $this->logger->addRequestURL($url);
            $this->logger->addRequestArgs(json_encode($requestData));
            $this->logger->addRequestEndpoint(substr($path, 0, 50)); // @ToDo - make column longer in WP api_log table
            $this->logger->setRequestTime(time());
        }
    }

    protected function setAfterCallLoggingInformation($statusCode, $responseBody, $error=null)
    {
        if ($this->logger !== null) {
            $this->logger->setResponseTime(time());
            $this->logger->addResponseStatusCode($statusCode);
            $this->logger->addRawResponse($error ? $error : $responseBody);
        }
    }


    protected function makeRequest($method, $path, $data=null)
    {
        if (!in_array($method, ['GET','POST','PUT'])) return null;

        $result = (object)[
            'success' => false,
            'method' => $method,
            'requestData' => $data
        ];

        if ($this->accessToken === null) {
            $accessToken = $this->authenticate();
            if (!$this->accessToken) {
                $result->error = 'unable to generate access token';
                return $result;
            }
        }

        $headers = [
            'Content-Type' => 'application/json',
            'Account-Context-Id' => $this->getNokiaAccountId(),
            'Authorization' => 'Bearer ' . $this->accessToken,
        ];

        try {
            $result->url = $url = $this->getNokiaApiUrl($path);
            $client = new Client(['verify' => false, 'timeout' => 4]);
            $options = [
                'headers' => $headers
            ];
            if ($data) $options['body'] = json_encode($data);
            $this->setPreCallLoggingInformation($method, $url, $data, $path);
            $response = $client->request($method, $url, $options);
            $contents = $response->getBody()->getContents();
            $this->setAfterCallLoggingInformation($response->getStatusCode(), $contents);
            $result->success = true;
            $result->data = json_decode($contents);
            $result->statusCode = $response->getStatusCode();

        } catch (\Exception $e){
            error_log('[Geosim makeRequest('.$method.' '.$url.')] FAILED - with - '.$e->getMessage());
            error_log('[Headers: ' . json_encode($headers)) . ']';
            error_log('[Body: ' . json_encode($data)) . ']';
            $result->error = $e->getMessage();
            $this->setAfterCallLoggingInformation($e->getCode(), null, $e->getMessage());
        }

        $this->requestStack[] = $result;

        return $result;
    }

    protected function authenticate()
    {
        try {
            $url = $this->getNokiaBaseUrl() . '/uam/auth/realms/'.$this->getNokiaRealmId().'/protocol/openid-connect/token';

            $client = new Client(['verify' => false, 'timeout' => 4]);
            $options = [
                'form_params' => [
                    'scope' => 'openid',
                    'client_id' => $this->getNokiaClientId(),
                    'grant_type' => 'password',
                    'username' => $this->apiLogin,
                    'password' => $this->apiPass,
                ]
            ];
            $response = $client->request('POST', $url, $options);
            $contents = $response->getBody()->getContents();
            $data = json_decode($contents);
            $this->accessToken = $data->access_token ?? null;

        } catch (\Exception $e){
            error_log('[Geosim Nokia authenticate(POST '.$url.')] FAILED - with - '.$e->getMessage());
        }
    }

    protected function getNokiaApiUrl($path)
    {
        return $this->getNokiaBaseUrl().'/'.$this->config->geosim->nokia->apiPath.'/'.$path;
    }

    protected function getNokiaBaseUrl()
    {
        return "https://".$this->config->geosim->nokia->apiUrl;
    }

    protected function getNokiaRealmId()
    {
        return $this->config->geosim->nokia->realmId;
    }

    protected function getNokiaClientId()
    {
        return $this->config->geosim->nokia->clientId;
    }

    protected function getNokiaAccountId()
    {
        return $this->config->geosim->nokia->accountId;
    }

    protected function getNokiaTenantId()
    {
        return $this->config->geosim->nokia->tenantId;
    }

    public function getRequestStack()
    {
        return $this->requestStack;
    }

}