<?php

namespace geosim\simentity;

use apexl\entityCore\Entity;
use geosim\simentity\operator\databaseOperator;

class sim extends Entity {

    protected $dbTable;
    /** @var databaseOperator */
    protected $operator;

    public function __construct($table = 'geosim_platform_data')
    {
        parent::__construct();
        $this->dbTable = $table;
        $this->setOperator(new databaseOperator($this->dbTable));
    }

    public function loadByOwner($ownerId){
        //we want to return an array of instantiated sim objects (one for each returned sim)
        return $this->loadSimsFromArray($this->operator->loadByOwnerId($ownerId));
    }

    public function store(){
        $this->operator->store($this->data);
        return $this;
    }

    public function update(){
        return $this->store();
    }

    public function loadAllByOwnerId(){
        $this->loadAll('ownerId');
    }

    public function loadAllByPlatform(){
        $this->loadAll('platform');
    }

    public function loadAll($key = 'iccid'){
        return $this->loadSimsFromArray($this->operatator->loadAll(), $key);
    }

    protected function loadSimsFromArray(array $sims, $key = 'iccid'){
        $numSims = count($sims);
        $loadedSims = [];
        for($i=0;$i<$numSims;++$i){
            //load a new sim record for each response.
            $sim = new sim();
            //allow for custom grouping (easy reports by platform, account, owner etc)
            if($key != 'iccid' && $key != 'msisdn'){
                $loadedSims[$sims[$i]->$key][] = $sim->load($sims[$i]->iccid);
            } else {
                $loadedSims[$sims[$i]->$key] = $sim->load($sims[$i]->iccid);
            }
        }
        return $loadedSims;
    }

    public function setDbTable($table = 'geosim_platform_data'){
        //no point switching the table if its the same.
        if($table !== $this->dbTable) {
            return new sim($table);
        }
        return $this;
    }

    public function loadByOwnerId($ownerId, $orderBy = [], $offset = NULL, $limit = NULL){
        return $this->loadSimsFromArray($this->operator->loadByOwnerId($ownerId, $orderBy, $offset, $limit));
    }

    public function load($id){
        $this->setData($this->operator->load($id)['data']);
        return $this;
    }

    public function getEntityType(){
        return self::class;
    }
}