<?php

namespace geosim\simentity\operator;

use apexl\entityCore\interfaces\EntityOperatorInterface;
use apexl\Vault\Vault;

class databaseOperator implements EntityOperatorInterface{
    protected $vault;
    protected $iccid;
    protected $dbTable;

    public function __construct($table){
        $this->vault = Vault::getInstance();
        $this->dbTable = $table;
    }

    public function load($id){
        $sim = $this->vault->select($this->dbTable)->fields()->where("msisdn", $id)->orWhere("iccid", $id)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $sim];
    }

    public function store($data){
        //first, are we inserting or updating
        if(isset($data['iccid']) && !empty($data['iccid'])) {
            $sim = $this->load($data['iccid']);
            if (!empty($sim['data'])) {
                //not empty? we have a record, so update.
                $this->vault->update($this->dbTable)->fields($data)->where('iccid', $data['iccid'])->execute();
                return TRUE;
            } else {
                //we're inserting to force an entity update in case we have a new primary key.
                $this->vault->insert($this->dbTable)->fields($data)->execute();
                return ['updateEntityData' => true, 'data' => $this->load($data['iccid'])];
            }
        }
        return FALSE; //no ICCID, no storing data.
    }

    public function delete($id){
        $this->vault->delete($this->dbTable)->where('iccid', $id)->execute();
    }

    public function loadByUserId($userId, $orderBy = [], $offset = NULL, $limit = NULL)
    {
        $query = $this->vault->select($this->dbTable)->fields('iccid')->where("userId", $userId);
        if(!empty($orderBy)){
            $query->orderBy($orderBy[0], $orderBy[1]);
        }
        if(!is_null($offset) && !is_null($limit)){
            $query->limit($limit, $offset);
        }
        return $query->execute()->fetchAll();
    }

    public function loadAll(){
        return $this->vault->select($this->dbTable)->execute()->fetchAll();
    }

    public function setVault($vault){
        $this->vault->setDefaultVault($vault);
        return $this;
    }

    public function resetVault(){
        $this->vault->setDefaultVault('default');
        return $this;
    }
}